//! The wumpus hunter.
//!
//! Run the automated test suite for a software project repeatedly, to
//! find flaky tests that fail only sometimes.
//!
//! This is the main program.

use clap::Parser;
use log::info;

use wumpus_hunter::{Args, Cmd};

fn main() -> anyhow::Result<()> {
    pretty_env_logger::init_custom_env("WUMPUS_LOG");
    info!("I smell a Wumpus");

    let args = Args::parse();
    match &args.cmd {
        Cmd::Run(x) => x.run(&args)?,
        Cmd::Report(x) => x.run()?,
        Cmd::DummyLog(x) => x.run(),
    }

    info!("Wumpus hunter is done");
    Ok(())
}
